using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace pokusaj4
{
    public class Tacka
    {
        public int X;
        public int Y;
        public Tacka(int x, int y)
        {
            X = x;
            Y = y;
        }
    }
    internal class Program
    {
        public static double PovrsinaKonveksnogOmotaca(List<Tacka> tacke)
        {
            var omotac = KonveksanOmotac(tacke);
            return PovrsinaPoligona(omotac);
        }
        public static List<Tacka> KonveksanOmotac(List<Tacka> tacke)
        {
            tacke = tacke.Where(t => t != null).Distinct().ToList();

           
            
            tacke = tacke.OrderBy(t => t.X).ThenBy(t=> t.Y).ToList();
            var visa = new List<Tacka>();

            var niza = new List<Tacka>();
            foreach(var t in tacke)
            {
                while (niza.Count >= 2 && VektorskiProizvod(niza[niza.Count - 2], niza[niza.Count - 1], t) <= 0)
                    niza.RemoveAt(niza.Count - 1);
                niza.Add(t);
            }
            tacke.Reverse();

            foreach(var t in tacke)
            {
                while(visa.Count >= 2 && VektorskiProizvod(visa[visa.Count - 2], visa[visa.Count-1],t) <=0 ) 
                    visa.RemoveAt(visa.Count -1);
                visa.Add(t);
            }
            niza.RemoveAt(niza.Count - 1);
            visa.RemoveAt(visa.Count - 1);

            niza.AddRange(visa);
            return niza;
        }
        public static double VektorskiProizvod(Tacka A,Tacka B, Tacka C)
        {
            return (B.X - A.X) * (C.Y - A.Y) - (B.Y - A.Y) * (C.X - A.X);
        }
        public static double PovrsinaPoligona(List<Tacka> tacke)
        {
            double P = 0;
            int N = tacke.Count;
            for(int i = 0;i< N;i++)
            {
                Tacka t1 = tacke[i];
                Tacka t2 = tacke[(i+1)%N];
                P += t1.X * t2.Y - t2.X * t1.Y;
            }
            return Math.Abs(P) / 2;
        }
        public static double NajmanjiKonveksniOmotac(Tacka[] tacke)
        {
            double minP = double.MaxValue;
            for(int i = 0;i<tacke.Length;i++)
            {
                var ostatak = tacke.Where((p,k) => k !=i).ToList();
                double P = PovrsinaKonveksnogOmotaca(ostatak);
                if(P < minP)
                    minP = P; 
            }
            return minP;
        }
        static void Main(string[] args)
        {
            int N = int.Parse( Console.ReadLine() );
        Tacka[] tacke = new Tacka[N];
        for(int i = 0;i<N;i++)
        {
            string[] ulaz = Console.ReadLine().Split(' ');
            int X = int.Parse( ulaz[0]);
            int Y = int.Parse ( ulaz[1]);
            Tacka p = new Tacka(X, Y);
            tacke[i] = p;
        }

        double res = NajmanjiKonveksniOmotac(tacke);
        Console.WriteLine(res);
        }
    }
}